/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.utils.CodecUtils;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2499;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record ItemPredicate(Optional<class_6885<class_1792>> items, class_2096.class_2100 count, class_2096.class_2100 durability, class_2035[] enchantments, class_2035[] storedEnchantments, Optional<class_1842> potion, class_2105 nbt) {
    public static final Codec<ItemPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41197).optionalFieldOf("items").forGetter(ItemPredicate::items), (App)CodecUtils.MIN_MAX_INT_CODEC.optionalFieldOf("count", (Object)class_2096.class_2100.field_9708).forGetter(ItemPredicate::count), (App)CodecUtils.MIN_MAX_INT_CODEC.optionalFieldOf("durability", (Object)class_2096.class_2100.field_9708).forGetter(ItemPredicate::durability), (App)CodecUtils.ENCHANTMENTS_PREDICATE_CODEC.optionalFieldOf("enchantments", (Object)class_2035.field_20687).forGetter(ItemPredicate::enchantments), (App)CodecUtils.ENCHANTMENTS_PREDICATE_CODEC.optionalFieldOf("stored_enchantments", (Object)class_2035.field_20687).forGetter(ItemPredicate::storedEnchantments), (App)CodecUtils.identifierResolver(arg_0 -> ((class_7922)class_7923.field_41179).method_10221(arg_0), arg_0 -> ((class_7922)class_7923.field_41179).method_10223(arg_0)).optionalFieldOf("potion").forGetter(ItemPredicate::potion), (App)CodecUtils.NBT_PREDICATE_CODEC.optionalFieldOf("nbt", (Object)class_2105.field_9716).forGetter(ItemPredicate::nbt)).apply((Applicative)instance, ItemPredicate::new));

    public boolean test(class_1799 stack) {
        Map enchantments;
        if (this.items.isPresent() && !this.items.get().method_40241(stack.method_41409())) {
            return false;
        }
        if (!this.count.method_9054(stack.method_7947())) {
            return false;
        }
        if (!this.durability.method_9041() && !stack.method_7963()) {
            return false;
        }
        if (!this.durability.method_9054(stack.method_7936() - stack.method_7919())) {
            return false;
        }
        if (!this.nbt.method_9074(stack)) {
            return false;
        }
        if (this.enchantments.length > 0) {
            enchantments = class_1890.method_22445((class_2499)stack.method_7921());
            for (class_2035 enchantmentPredicate : this.enchantments) {
                if (enchantmentPredicate.method_8880(enchantments)) continue;
                return false;
            }
        }
        if (this.storedEnchantments.length > 0) {
            enchantments = class_1890.method_22445((class_2499)class_1772.method_7806((class_1799)stack));
            for (class_2035 enchantmentPredicate : this.storedEnchantments) {
                if (enchantmentPredicate.method_8880(enchantments)) continue;
                return false;
            }
        }
        class_1842 potion = class_1844.method_8063((class_1799)stack);
        return this.potion.isEmpty() || this.potion.get() == potion;
    }

    public static class Builder {
        private Optional<class_6885<class_1792>> items = Optional.empty();
        private class_2096.class_2100 count = class_2096.class_2100.field_9708;
        private class_2096.class_2100 durability = class_2096.class_2100.field_9708;

        private Builder() {
        }

        public static Builder item() {
            return new Builder();
        }

        public Builder of(class_1935 ... items) {
            this.items = Optional.of(class_6885.method_40245(itemLike -> itemLike.method_8389().method_40131(), (Object[])items));
            return this;
        }

        public Builder of(class_6862<class_1792> tag) {
            this.items = Optional.of(class_7923.field_41178.method_40260(tag));
            return this;
        }

        public Builder withCount(class_2096.class_2100 count) {
            this.count = count;
            return this;
        }

        public Builder withDurability(class_2096.class_2100 durability) {
            this.durability = durability;
            return this;
        }

        public ItemPredicate build() {
            return new ItemPredicate(this.items, this.count, this.durability, new class_2035[0], new class_2035[0], Optional.empty(), class_2105.field_9716);
        }
    }
}

